package com.wissamfawaz;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class Main {
    public static void main(String[] args) {
        String[] colors1 = { "White", "Black" };
        List<String> colors1AsLL = new LinkedList<>(Arrays.asList(colors1));
        System.out.println("List#1: " + colors1AsLL);

        String[] colors2 = { "Red", "Blue", "Green" };
        List<String> colors2AsLL = new LinkedList<>();
        for (String color : colors2) {
            colors2AsLL.add(color);
        }

        System.out.println("List#2: " + colors2AsLL);

        colors1AsLL.addAll(colors2AsLL);
        System.out.println("Combined lists: " + colors1AsLL);

        printReversedList(colors1AsLL);
        convertToUpperCase(colors1AsLL);

        System.out.println("Colors converted into uppercase: " + colors1AsLL);

        removeItems(colors1AsLL, 1, 3);
        System.out.println("After removal: " + colors1AsLL);
    }

    private static void printReversedList(List<String> list) {
        ListIterator<String> listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            System.out.print(listIterator.previous() + " ");
        }
        System.out.println();
    }

    private static void convertToUpperCase(List<String> list) {
        ListIterator<String> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            listIterator.set(listIterator.next().toUpperCase());
        }
    }

    private static void removeItems(List<String> list, int start, int end) {
        list.subList(start, end).clear();
    }
}
